/////////////////////////////////////////////
//      UNITECH Web Toolbar Functions      //
/////////////////////////////////////////////
//These functions will only work with the
//UNITECH Web Toolbar.  They will not cause
//errors, or otherwise change the behavior of
//an assignable unit, if the course is not
//a UNITECH course.

function disableNav()
{
	if (navigateEventCallbackId) toolbarAPI.unregisterEvent(navigateEventCallbackId);
	navigateEventCallbackId = toolbarAPI.registerEvent("navigate","speedBump", window);
}

function enableNav()
{
	toolbarAPI.unregisterEvent(navigateEventCallbackId);
	navigateEventCallbackId = null;
}

function subtopicChange(subTopic)
{
	var childNum = subTopic.charCodeAt(0)-96;
	nodeAPI.gotoNode(nodeId + "." + childNum);
}

function speedBump()
{
	var value = confirm("You are about to leave this page without completing the exercise.  Click 'OK' to leave, or 'Cancel' to remain on this page.");
	if (value) return true;
	else return false;
}

function IsUnitechCourse()
{
	if (toolbarAPI._winRef)
	{
		return true;
	}
	else
	{
		return false;
	}
}

function pageLoaded()
{
	initializePage();

	toolbarAPI.unregisterEvent(audioButtonCallbackId);
	toolbarAPI.unregisterEvent(videoButtonCallbackId);
	toolbarAPI.unregisterEvent(moreButtonCallbackId);

	audioButtonCallbackId = toolbarAPI.registerEvent("audiobuttonclick","playPageAudio", window);
	videoButtonCallbackId = toolbarAPI.registerEvent("videobuttonclick","playPageVideo", window);
	moreButtonCallbackId = toolbarAPI.registerEvent("morebuttonclick","showMore", window);

	if (moreBox)
	{
		toolbarAPI.executeMethod("enableButton","MoreButton");
		if (videoClip && (getLayerRef("VideoLayer") != null))
		{
			moreTimerId = setInterval("moreAdjust()",1000);
		}
	}
	if (G2_getClipRef("AUDIO_CLIP"))
	{
		toolbarAPI.executeMethod("enableButton","AudioButton");
	}
	if (G2_getClipRef("VIDEO_CLIP"))
	{
		toolbarAPI.executeMethod("enableButton","VideoButton");
	}
	
	nodeAPI.setNodeAttempted(true);
	if (!window.manualSetCompleted)
	{
		nodeAPI.setNodeCompleted(true);
	}
}

function showMore()
{
	layerToFront("MoreBack");
	showLayer("MoreBack");
	layerToFront("MoreText");
	showLayer("MoreText");
	layerToFront("MoreImage");
	showLayer("MoreImage");
}

function playPageAudio()
{
	if (G2_getClipRef("AUDIO_CLIP"))
	{
		FP_stopAllClips();
		G2_play("AUDIO_CLIP");
	}
}

function playPageVideo()
{
	if (G2_getClipRef("VIDEO_CLIP"))
	{
		FP_stopAllClips();
		G2_play("VIDEO_CLIP");
	}
}

function pageUnloaded()
{
	if (G2_getClipRef("AUDIO_CLIP"))
	{
		toolbarAPI.executeMethod("disableButton","AudioButton");
	}
	if (G2_getClipRef("VIDEO_CLIP"))
	{
		toolbarAPI.executeMethod("disableButton","VideoButton");
	}

	terminatePage();
}

function isAudioPage()
{
	if (G2_getClipRef("AUDIO_CLIP") != null)
	{
		return true;
	}
	else
	{
		return false;
	}
}

function getPageName()
{
	var retVal = cleanupURL(document.URL);
	retVal = retVal.slice(0,retVal.lastIndexOf("."));
	retVal = retVal.slice(retVal.lastIndexOf("/")+1,retVal.length);
	return retVal;
}

function cleanupURL(url)
{
	url = url + "";
	for (var i=0;i<url.length;i++)
	{
		if (url.charCodeAt(i) < 32 || url.charCodeAt(i) > 126)
		{
			url = url.slice(0,i) + url.slice(i+1,url.length);
		} 
		else if (url.charAt(i) == "\\")
		{
			url = url.slice(0,i) + "/" + url.slice(i+1,url.length);
		}
	}
	return url;
}

